/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.reports;

import java.text.DecimalFormat;
import java.util.List;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamStudent;
import net.sf.cpsolver.ifs.util.CSVFile;

public class ExamStudentDirectConflicts {
    private ExamModel iModel = null;

    public ExamStudentDirectConflicts(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report() {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("Exam 1"), new CSVFile.CSVField("Enrl 1"), new CSVFile.CSVField("Period 1"), new CSVFile.CSVField("Date 1"), new CSVFile.CSVField("Time 1"), new CSVFile.CSVField("Exam 2"), new CSVFile.CSVField("Enrl 2"), new CSVFile.CSVField("Direct"), new CSVFile.CSVField("Direct [%]")});
        DecimalFormat df = new DecimalFormat("0.0");
        for (Exam ex1 : this.iModel.variables()) {
            ExamPlacement p1 = (ExamPlacement)ex1.getAssignment();
            if (p1 == null) continue;
            for (Exam ex2 : this.iModel.variables()) {
                List<ExamStudent> students;
                ExamPlacement p2;
                if (ex1.getId() >= ex2.getId() || (p2 = (ExamPlacement)ex2.getAssignment()) == null || !p2.getPeriod().equals(p1.getPeriod()) || (students = ex1.getJointEnrollments().get(ex2)) == null || students.isEmpty()) continue;
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(ex1.getName()), new CSVFile.CSVField(ex1.getStudents().size()), new CSVFile.CSVField(p1.getPeriod().getIndex() + 1), new CSVFile.CSVField(p1.getPeriod().getDayStr()), new CSVFile.CSVField(p1.getPeriod().getTimeStr()), new CSVFile.CSVField(ex2.getName()), new CSVFile.CSVField(ex2.getStudents().size()), new CSVFile.CSVField(students.size()), new CSVFile.CSVField(df.format(100.0 * (double)students.size() / (double)Math.min(ex1.getStudents().size(), ex2.getStudents().size())))});
            }
        }
        return csv;
    }
}

