/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.reports;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.ifs.util.CSVFile;

public class ExamAssignments {
    private ExamModel iModel = null;

    public ExamAssignments(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report() {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("Exam"), new CSVFile.CSVField("Enrl"), new CSVFile.CSVField("Alt"), new CSVFile.CSVField("Period"), new CSVFile.CSVField("Date"), new CSVFile.CSVField("Time"), new CSVFile.CSVField("Room"), new CSVFile.CSVField("Cap")});
        for (Exam exam : this.iModel.variables()) {
            ExamPlacement placement = (ExamPlacement)exam.getAssignment();
            ArrayList<CSVFile.CSVField> fields = new ArrayList<CSVFile.CSVField>();
            fields.add(new CSVFile.CSVField(exam.getName()));
            fields.add(new CSVFile.CSVField(exam.getStudents().size()));
            fields.add(new CSVFile.CSVField(exam.hasAltSeating() ? "Yes" : "No"));
            if (placement == null) {
                fields.add(new CSVFile.CSVField(""));
                fields.add(new CSVFile.CSVField(""));
                fields.add(new CSVFile.CSVField(""));
                fields.add(new CSVFile.CSVField(""));
                fields.add(new CSVFile.CSVField(""));
            } else {
                fields.add(new CSVFile.CSVField(placement.getPeriod().getIndex() + 1));
                fields.add(new CSVFile.CSVField(placement.getPeriod().getDayStr()));
                fields.add(new CSVFile.CSVField(placement.getPeriod().getTimeStr()));
                String rooms = "";
                String roomSizes = "";
                Iterator<ExamRoomPlacement> i = placement.getRoomPlacements().iterator();
                while (i.hasNext()) {
                    ExamRoomPlacement room = i.next();
                    rooms = rooms + room.getRoom().getName();
                    roomSizes = roomSizes + room.getSize(exam.hasAltSeating());
                    if (!i.hasNext()) continue;
                    rooms = rooms + ", ";
                    roomSizes = roomSizes + ", ";
                }
                fields.add(new CSVFile.CSVField(rooms));
                fields.add(new CSVFile.CSVField(roomSizes));
            }
            csv.addLine(fields);
        }
        return csv;
    }
}

