/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.coursett.IdConvertor;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomSharing;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.util.DataProperties;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedExamRoomSharing
extends ExamRoomSharing {
    private Map<Long, Set<Long>> iSharingMatrix = new HashMap<Long, Set<Long>>();

    public PredefinedExamRoomSharing(Model<Exam, ExamPlacement> model, DataProperties config) {
        super(model, config);
    }

    @Override
    public boolean canShareRoom(Exam x1, Exam x2) {
        if (x1.getId() < x2.getId()) {
            Set<Long> exams = this.iSharingMatrix.get(x1.getId());
            return exams != null && exams.contains(x2.getId());
        }
        Set<Long> exams = this.iSharingMatrix.get(x2.getId());
        return exams != null && exams.contains(x1.getId());
    }

    public void addPair(Exam x1, Exam x2) {
        this.addPair(x1.getId(), x2.getId());
    }

    public void addPair(Long examId1, Long examId2) {
        if (examId1 < examId2) {
            Set<Long> exams = this.iSharingMatrix.get(examId1);
            if (exams == null) {
                exams = new HashSet<Long>();
                this.iSharingMatrix.put(examId1, exams);
            }
            exams.add(examId2);
        } else {
            Set<Long> exams = this.iSharingMatrix.get(examId2);
            if (exams == null) {
                exams = new HashSet<Long>();
                this.iSharingMatrix.put(examId2, exams);
            }
            exams.add(examId1);
        }
    }

    public void clear() {
        this.iSharingMatrix.clear();
    }

    @Override
    public void save(Exam exam, Element element, IdConvertor idConvertor) {
        Set<Long> exams = this.iSharingMatrix.get(exam.getId());
        if (exams != null) {
            String ids = "";
            for (Long id : exams) {
                if (!ids.isEmpty()) {
                    ids = ids + ",";
                }
                ids = ids + (idConvertor == null ? id.toString() : idConvertor.convert("exam", id.toString()));
            }
            element.addElement("canShareRoom").setText(ids);
        }
    }

    @Override
    public void load(Exam exam, Element element) {
        Element canShareRoom = element.element("canShareRoom");
        if (canShareRoom == null) {
            return;
        }
        for (String id : canShareRoom.getTextTrim().split(",")) {
            this.addPair(exam.getId(), Long.valueOf(id.trim()));
        }
    }
}

