/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamOwner;
import net.sf.cpsolver.exam.model.ExamPeriod;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.model.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamStudent
extends Constraint<Exam, ExamPlacement> {
    private Set<Exam>[] iTable;
    private Set<Exam>[] iDayTable;
    private boolean iAllowDirectConflicts = true;
    private List<ExamOwner> iOwners = new ArrayList<ExamOwner>();
    private boolean[] iAvailable = null;

    public ExamStudent(ExamModel model, long id) {
        int i;
        this.iAllowDirectConflicts = model.getProperties().getPropertyBoolean("Student.AllowDirectConflicts", this.iAllowDirectConflicts);
        this.iAssignedVariables = null;
        this.iId = id;
        this.iTable = new Set[model.getNrPeriods()];
        for (i = 0; i < this.iTable.length; ++i) {
            this.iTable[i] = new HashSet<Exam>();
        }
        this.iDayTable = new Set[model.getNrDays()];
        for (i = 0; i < this.iDayTable.length; ++i) {
            this.iDayTable[i] = new HashSet<Exam>();
        }
    }

    public boolean isAllowDirectConflicts() {
        return this.iAllowDirectConflicts;
    }

    public void setAllowDirectConflicts(boolean allowDirectConflicts) {
        this.iAllowDirectConflicts = allowDirectConflicts;
    }

    public boolean canConflict(Exam ex1, Exam ex2) {
        return this.isAllowDirectConflicts() && ex1.isAllowDirectConflicts() && ex2.isAllowDirectConflicts();
    }

    public Set<Exam> getExams(ExamPeriod period) {
        return this.iTable[period.getIndex()];
    }

    public Set<Exam> getExamsADay(ExamPeriod period) {
        return this.iDayTable[period.getDay()];
    }

    public Set<Exam> getExamsADay(int day) {
        return this.iDayTable[day];
    }

    @Override
    public void computeConflicts(ExamPlacement p, Set<ExamPlacement> conflicts) {
        Exam ex = (Exam)p.variable();
        for (Exam exam : this.iTable[p.getPeriod().getIndex()]) {
            if (this.canConflict(ex, exam)) continue;
            conflicts.add((ExamPlacement)exam.getAssignment());
        }
    }

    @Override
    public boolean inConflict(ExamPlacement p) {
        Exam ex = (Exam)p.variable();
        for (Exam exam : this.iTable[p.getPeriod().getIndex()]) {
            if (this.canConflict(ex, exam)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent(ExamPlacement p1, ExamPlacement p2) {
        return p1.getPeriod() != p2.getPeriod() || this.canConflict((Exam)p1.variable(), (Exam)p2.variable());
    }

    public void afterAssigned(long iteration, ExamPlacement value) {
        ExamPlacement p = value;
        this.iTable[p.getPeriod().getIndex()].add((Exam)value.variable());
        this.iDayTable[p.getPeriod().getDay()].add((Exam)value.variable());
    }

    public void afterUnassigned(long iteration, ExamPlacement value) {
        ExamPlacement p = value;
        this.iTable[p.getPeriod().getIndex()].remove(value.variable());
        this.iDayTable[p.getPeriod().getDay()].remove(value.variable());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamStudent)) {
            return false;
        }
        ExamStudent s = (ExamStudent)o;
        return this.getId() == s.getId();
    }

    @Override
    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    public String toString() {
        return String.valueOf(this.getId());
    }

    @Override
    public int compareTo(Constraint<Exam, ExamPlacement> o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public boolean isHard() {
        return !this.isAllowDirectConflicts();
    }

    public List<ExamOwner> getOwners() {
        return this.iOwners;
    }

    public boolean isAvailable(ExamPeriod period) {
        return this.iAvailable == null ? true : this.iAvailable[period.getIndex()];
    }

    public void setAvailable(int period, boolean available) {
        if (this.iAvailable == null) {
            this.iAvailable = new boolean[this.iTable.length];
            for (int i = 0; i < this.iTable.length; ++i) {
                this.iAvailable[i] = true;
            }
        }
        this.iAvailable[period] = available;
    }
}

