/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.coursett.IdConvertor;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoom;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExamRoomSharing {
    public ExamRoomSharing(Model<Exam, ExamPlacement> model, DataProperties config) {
    }

    public boolean inConflict(ExamPlacement exam, Collection<ExamPlacement> other, ExamRoom room) {
        if (exam.getRoomPlacements().size() != 1) {
            return !other.isEmpty();
        }
        return this.inConflict((Exam)exam.variable(), other, room);
    }

    public boolean inConflict(Exam exam, Collection<ExamPlacement> other, ExamRoom room) {
        int total = exam.getSize();
        boolean altSeating = exam.hasAltSeating();
        for (ExamPlacement x : other) {
            if (((Exam)x.variable()).equals(exam)) continue;
            if (x.getRoomPlacements().size() != 1) {
                return true;
            }
            if (!this.canShareRoom(exam, (Exam)x.variable())) {
                return true;
            }
            total += ((Exam)x.variable()).getSize();
            if (!((Exam)x.variable()).hasAltSeating()) continue;
            altSeating = true;
        }
        return total > (altSeating ? room.getAltSize() : room.getSize());
    }

    public void computeConflicts(ExamPlacement exam, Collection<ExamPlacement> other, ExamRoom room, Set<ExamPlacement> conflicts) {
        if (exam.getRoomPlacements().size() != 1) {
            conflicts.addAll(other);
            return;
        }
        this.computeConflicts((Exam)exam.variable(), other, room, conflicts);
    }

    public void computeConflicts(Exam exam, Collection<ExamPlacement> other, ExamRoom room, Set<ExamPlacement> conflicts) {
        int total = exam.getSize();
        boolean altSeating = exam.hasAltSeating();
        ArrayList<ExamPlacement> adepts = new ArrayList<ExamPlacement>();
        for (ExamPlacement x : other) {
            if (((Exam)x.variable()).equals(exam)) continue;
            if (x.getRoomPlacements().size() != 1) {
                conflicts.add(x);
                continue;
            }
            if (!this.canShareRoom(exam, (Exam)x.variable())) {
                conflicts.add(x);
                continue;
            }
            if (((Exam)x.variable()).hasAltSeating()) {
                altSeating = true;
            }
            total += ((Exam)x.variable()).getSize();
            adepts.add(x);
        }
        while (total > (altSeating ? room.getAltSize() : room.getSize()) && !adepts.isEmpty()) {
            ExamPlacement x = (ExamPlacement)ToolBox.random(adepts);
            adepts.remove(x);
            conflicts.add(x);
            total -= ((Exam)x.variable()).getSize();
        }
    }

    public abstract boolean canShareRoom(Exam var1, Exam var2);

    public void save(Exam exam, Element element, IdConvertor idConvertor) {
    }

    public void load(Exam exam, Element element) {
    }
}

