/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.model;

import net.sf.cpsolver.exam.model.ExamPeriod;
import net.sf.cpsolver.exam.model.ExamRoom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamRoomPlacement
implements Comparable<ExamRoomPlacement> {
    private ExamRoom iRoom;
    private int iPenalty = 0;
    private int iMaxPenalty = 100;

    public ExamRoomPlacement(ExamRoom room) {
        this.iRoom = room;
    }

    public ExamRoomPlacement(ExamRoom room, int penalty) {
        this(room);
        this.iPenalty = penalty;
    }

    public ExamRoomPlacement(ExamRoom room, int penalty, int maxPenalty) {
        this(room, penalty);
        this.iMaxPenalty = maxPenalty;
    }

    public ExamRoom getRoom() {
        return this.iRoom;
    }

    public long getId() {
        return this.getRoom().getId();
    }

    public String getName() {
        return this.getRoom().getName();
    }

    public boolean isAvailable(ExamPeriod period) {
        return this.iRoom.isAvailable(period) && this.iRoom.getPenalty(period) <= this.iMaxPenalty;
    }

    public int getPenalty() {
        return this.iPenalty;
    }

    public int getMaxPenalty() {
        return this.iMaxPenalty;
    }

    public void setPenalty(int penalty) {
        this.iPenalty = penalty;
    }

    public void setMaxPenalty(int maxPenalty) {
        this.iMaxPenalty = maxPenalty;
    }

    public int getPenalty(ExamPeriod period) {
        return 2 * this.iPenalty + this.iRoom.getPenalty(period);
    }

    public int getSize(boolean altSeating) {
        return altSeating ? this.getRoom().getAltSize() : this.getRoom().getSize();
    }

    public double getDistanceInMeters(ExamRoomPlacement other) {
        return this.getRoom().getDistanceInMeters(other.getRoom());
    }

    public int hashCode() {
        return this.getRoom().hashCode();
    }

    public String toString() {
        return this.getRoom().toString() + (this.getPenalty() == 0 ? "" : "/" + this.getPenalty());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ExamRoomPlacement) {
            return this.getRoom().equals(((ExamRoomPlacement)o).getRoom());
        }
        if (o instanceof ExamRoom) {
            return this.getRoom().equals(o);
        }
        return false;
    }

    @Override
    public int compareTo(ExamRoomPlacement o) {
        return this.getRoom().compareTo(o.getRoom());
    }
}

