/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.model;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPeriod;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamRoom;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.model.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamPlacement
extends Value<Exam, ExamPlacement> {
    private ExamPeriodPlacement iPeriodPlacement;
    private Set<ExamRoomPlacement> iRoomPlacements;
    private Integer iHashCode = null;

    public ExamPlacement(Exam exam, ExamPeriodPlacement periodPlacement, Set<ExamRoomPlacement> roomPlacements) {
        super(exam);
        this.iPeriodPlacement = periodPlacement;
        this.iRoomPlacements = roomPlacements == null ? new HashSet<ExamRoomPlacement>() : roomPlacements;
    }

    public ExamPeriod getPeriod() {
        return this.iPeriodPlacement.getPeriod();
    }

    public ExamPeriodPlacement getPeriodPlacement() {
        return this.iPeriodPlacement;
    }

    public Set<ExamRoomPlacement> getRoomPlacements() {
        return this.iRoomPlacements;
    }

    public double getDistanceInMeters(ExamPlacement other) {
        if (this.getRoomPlacements().isEmpty() || other.getRoomPlacements().isEmpty()) {
            return 0.0;
        }
        double maxDistance = 0.0;
        for (ExamRoomPlacement r1 : this.getRoomPlacements()) {
            for (ExamRoomPlacement r2 : other.getRoomPlacements()) {
                maxDistance = Math.max(maxDistance, r1.getDistanceInMeters(r2));
            }
        }
        return maxDistance;
    }

    @Override
    public double toDouble() {
        double ret = 0.0;
        for (Criterion criterion : ((Exam)this.variable()).getModel().getCriteria()) {
            ret += criterion.getWeightedValue(this, null);
        }
        return ret;
    }

    public double getTimeCost() {
        double weight = 0.0;
        for (Criterion criterion : ((Exam)this.variable()).getModel().getCriteria()) {
            if (!((ExamCriterion)criterion).isPeriodCriterion()) continue;
            weight += criterion.getWeight() * ((ExamCriterion)criterion).getPeriodValue(this);
        }
        return weight;
    }

    public double getRoomCost() {
        double weight = 0.0;
        for (Criterion criterion : ((Exam)this.variable()).getModel().getCriteria()) {
            if (!((ExamCriterion)criterion).isRoomCriterion()) continue;
            weight += criterion.getWeight() * ((ExamCriterion)criterion).getRoomValue(this);
        }
        return weight;
    }

    public String getRoomName(String delim) {
        String roomName = "";
        Iterator<ExamRoomPlacement> i = this.getRoomPlacements().iterator();
        while (i.hasNext()) {
            ExamRoomPlacement r = i.next();
            roomName = roomName + r.getRoom().getName();
            if (!i.hasNext()) continue;
            roomName = roomName + delim;
        }
        return roomName;
    }

    @Override
    public String getName() {
        return this.getPeriod() + " " + this.getRoomName(",");
    }

    @Override
    public String toString() {
        String ret = "";
        for (Criterion criterion : ((Exam)this.variable()).getModel().getCriteria()) {
            String val = criterion.toString();
            if (val.isEmpty()) continue;
            ret = ret + (!ret.isEmpty() && !ret.endsWith(",") ? "," : "") + val;
        }
        return ((Exam)this.variable()).getName() + " = " + this.getName() + " (" + new DecimalFormat("0.00").format(this.toDouble()) + "/" + ret + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamPlacement)) {
            return false;
        }
        ExamPlacement p = (ExamPlacement)o;
        return ((Exam)p.variable()).equals(this.variable()) && p.getPeriod().equals(this.getPeriod()) && p.getRoomPlacements().equals(this.getRoomPlacements());
    }

    @Override
    public int hashCode() {
        if (this.iHashCode == null) {
            this.iHashCode = this.getName().hashCode();
        }
        return this.iHashCode;
    }

    public boolean contains(ExamRoom room) {
        return this.getRoomPlacements().contains(new ExamRoomPlacement(room));
    }
}

