/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.heuristics;

import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.heuristics.VariableSelection;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamUnassignedVariableSelection
implements VariableSelection<Exam, ExamPlacement> {
    private boolean iRandomSelection = true;

    public ExamUnassignedVariableSelection(DataProperties properties) {
        this.iRandomSelection = properties.getPropertyBoolean("ExamUnassignedVariableSelection.random", this.iRandomSelection);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    @Override
    public Exam selectVariable(Solution<Exam, ExamPlacement> solution) {
        ExamModel model = (ExamModel)solution.getModel();
        if (model.nrUnassignedVariables() == 0) {
            return null;
        }
        if (this.iRandomSelection) {
            return (Exam)ToolBox.random(model.unassignedVariables());
        }
        Exam variable = null;
        for (Exam v : model.unassignedVariables()) {
            if (variable != null && v.compareTo(variable) >= 0) continue;
            variable = v;
        }
        return variable;
    }
}

