/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.heuristics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.ifs.extension.ConflictStatistics;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.heuristics.ValueSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.SimpleNeighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamTabuSearch
implements NeighbourSelection<Exam, ExamPlacement>,
ValueSelection<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamTabuSearch.class);
    private ConflictStatistics<Exam, ExamPlacement> iStat = null;
    private long iFirstIteration = -1L;
    private long iMaxIdleIterations = 10000L;
    private int iTabuMinSize = 0;
    private int iTabuMaxSize = 0;
    private TabuList iTabu = null;
    private double iConflictWeight = 1000000.0;
    private double iValueWeight = 1.0;

    public ExamTabuSearch(DataProperties properties) throws Exception {
        this.iTabuMinSize = properties.getPropertyInt("TabuSearch.MinSize", this.iTabuMinSize);
        this.iTabuMaxSize = properties.getPropertyInt("TabuSearch.MaxSize", this.iTabuMaxSize);
        if (this.iTabuMaxSize > 0) {
            this.iTabu = new TabuList(this.iTabuMinSize);
        }
        this.iMaxIdleIterations = properties.getPropertyLong("TabuSearch.MaxIdle", this.iMaxIdleIterations);
        this.iConflictWeight = properties.getPropertyDouble("Value.ConflictWeight", this.iConflictWeight);
        this.iValueWeight = properties.getPropertyDouble("Value.ValueWeight", this.iValueWeight);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        for (Extension<Exam, ExamPlacement> extension : solver.getExtensions()) {
            if (!ConflictStatistics.class.isInstance(extension)) continue;
            this.iStat = (ConflictStatistics)extension;
        }
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        long idle;
        if (this.iFirstIteration < 0L) {
            this.iFirstIteration = solution.getIteration();
        }
        if ((idle = solution.getIteration() - Math.max(this.iFirstIteration, solution.getBestIteration())) > this.iMaxIdleIterations) {
            sLog.debug((Object)"  [tabu]    max idle iterations reached");
            this.iFirstIteration = -1L;
            if (this.iTabu != null) {
                this.iTabu.clear();
            }
            return null;
        }
        if (this.iTabu != null && this.iTabuMaxSize > this.iTabuMinSize) {
            if (idle == 0L) {
                this.iTabu.resize(this.iTabuMinSize);
            } else if (idle % (this.iMaxIdleIterations / (long)(this.iTabuMaxSize - this.iTabuMinSize)) == 0L) {
                this.iTabu.resize(Math.min(this.iTabuMaxSize, this.iTabu.size() + 1));
            }
        }
        boolean acceptConflicts = solution.getModel().getBestUnassignedVariables() > 0;
        ExamModel model = (ExamModel)solution.getModel();
        double bestEval = 0.0;
        ArrayList<ExamPlacement> best = null;
        for (Exam exam : model.variables()) {
            ExamPlacement assigned = (ExamPlacement)exam.getAssignment();
            double assignedVal = assigned == null ? this.iConflictWeight : this.iValueWeight * assigned.toDouble();
            for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
                int un;
                ExamPlacement value;
                Set<ExamRoomPlacement> rooms = exam.findBestAvailableRooms(period);
                if (rooms == null) {
                    rooms = exam.findRoomsRandom(period, false);
                }
                if (rooms == null || (value = new ExamPlacement(exam, period, rooms)).equals(assigned)) continue;
                double eval = this.iValueWeight * value.toDouble() - assignedVal;
                if (acceptConflicts) {
                    Set<ExamPlacement> conflicts = model.conflictValues(value);
                    for (ExamPlacement conflict : conflicts) {
                        eval -= this.iValueWeight * conflict.toDouble();
                        eval += this.iConflictWeight * (1.0 + (this.iStat == null ? 0.0 : this.iStat.countRemovals(solution.getIteration(), conflict, value)));
                    }
                } else if (model.inConflict(value)) continue;
                if (this.iTabu != null && this.iTabu.contains(exam.getId() + ":" + value.getPeriod().getIndex()) && ((un = model.nrUnassignedVariables() - (assigned == null ? 0 : 1)) > model.getBestUnassignedVariables() || un == model.getBestUnassignedVariables() && model.getTotalValue() + eval >= solution.getBestValue())) continue;
                if (best == null || bestEval > eval) {
                    if (best == null) {
                        best = new ArrayList<ExamPlacement>();
                    } else {
                        best.clear();
                    }
                    best.add(value);
                    bestEval = eval;
                    continue;
                }
                if (bestEval != eval) continue;
                best.add(value);
            }
        }
        if (best == null) {
            sLog.debug((Object)"  [tabu] --none--");
            this.iFirstIteration = -1L;
            if (this.iTabu != null) {
                this.iTabu.clear();
            }
            return null;
        }
        ExamPlacement bestVal = (ExamPlacement)ToolBox.random(best);
        if (sLog.isDebugEnabled()) {
            Set<ExamPlacement> conflicts = model.conflictValues(bestVal);
            double wconf = this.iStat == null ? 0.0 : this.iStat.countRemovals(solution.getIteration(), (ExamPlacement)((Object)conflicts), bestVal);
            sLog.debug((Object)("  [tabu] " + bestVal + " (" + (((Exam)bestVal.variable()).getAssignment() == null ? "" : "was=" + ((Exam)bestVal.variable()).getAssignment() + ", ") + "val=" + bestEval + (conflicts.isEmpty() ? "" : ", conf=" + (wconf + (double)conflicts.size()) + "/" + conflicts) + ")"));
        }
        if (this.iTabu != null) {
            this.iTabu.add(((Exam)bestVal.variable()).getId() + ":" + bestVal.getPeriod().getIndex());
        }
        return new SimpleNeighbour<Exam, ExamPlacement>((Exam)bestVal.variable(), bestVal);
    }

    @Override
    public ExamPlacement selectValue(Solution<Exam, ExamPlacement> solution, Exam exam) {
        long idle;
        if (this.iFirstIteration < 0L) {
            this.iFirstIteration = solution.getIteration();
        }
        if ((idle = solution.getIteration() - Math.max(this.iFirstIteration, solution.getBestIteration())) > this.iMaxIdleIterations) {
            sLog.debug((Object)"  [tabu]    max idle iterations reached");
            this.iFirstIteration = -1L;
            if (this.iTabu != null) {
                this.iTabu.clear();
            }
            return null;
        }
        if (this.iTabu != null && this.iTabuMaxSize > this.iTabuMinSize) {
            if (idle == 0L) {
                this.iTabu.resize(this.iTabuMinSize);
            } else if (idle % (this.iMaxIdleIterations / (long)(this.iTabuMaxSize - this.iTabuMinSize)) == 0L) {
                this.iTabu.resize(Math.min(this.iTabuMaxSize, this.iTabu.size() + 1));
            }
        }
        ExamModel model = (ExamModel)solution.getModel();
        double bestEval = 0.0;
        ArrayList<ExamPlacement> best = null;
        ExamPlacement assigned = (ExamPlacement)exam.getAssignment();
        double assignedVal = assigned == null ? this.iConflictWeight : this.iValueWeight * assigned.toDouble();
        for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
            int un;
            Set<ExamRoomPlacement> rooms = exam.findBestAvailableRooms(period);
            if (rooms == null) {
                rooms = exam.findRoomsRandom(period, false);
            }
            if (rooms == null) {
                sLog.info((Object)("Exam " + exam.getName() + " has no rooms for period " + period));
                continue;
            }
            ExamPlacement value = new ExamPlacement(exam, period, rooms);
            if (value.equals(assigned)) continue;
            Set<ExamPlacement> conflicts = model.conflictValues(value);
            double eval = this.iValueWeight * value.toDouble() - assignedVal;
            for (ExamPlacement conflict : conflicts) {
                eval -= this.iValueWeight * conflict.toDouble();
                eval += this.iConflictWeight * (1.0 + (this.iStat == null ? 0.0 : this.iStat.countRemovals(solution.getIteration(), conflict, value)));
            }
            if (this.iTabu != null && this.iTabu.contains(exam.getId() + ":" + value.getPeriod().getIndex()) && ((un = model.nrUnassignedVariables() - (assigned == null ? 0 : 1)) > model.getBestUnassignedVariables() || un == model.getBestUnassignedVariables() && model.getTotalValue() + eval >= solution.getBestValue())) continue;
            if (best == null || bestEval > eval) {
                if (best == null) {
                    best = new ArrayList<ExamPlacement>();
                } else {
                    best.clear();
                }
                best.add(value);
                bestEval = eval;
                continue;
            }
            if (bestEval != eval) continue;
            best.add(value);
        }
        if (best == null) {
            return null;
        }
        ExamPlacement bestVal = (ExamPlacement)ToolBox.random(best);
        if (sLog.isDebugEnabled()) {
            Set<ExamPlacement> conflicts = model.conflictValues(bestVal);
            double wconf = this.iStat == null ? 0.0 : this.iStat.countRemovals(solution.getIteration(), (ExamPlacement)((Object)conflicts), bestVal);
            sLog.debug((Object)("  [tabu] " + bestVal + " (" + (((Exam)bestVal.variable()).getAssignment() == null ? "" : "was=" + ((Exam)bestVal.variable()).getAssignment() + ", ") + "val=" + bestEval + (conflicts.isEmpty() ? "" : ", conf=" + (wconf + (double)conflicts.size()) + "/" + conflicts) + ")"));
        }
        if (this.iTabu != null) {
            this.iTabu.add(exam.getId() + ":" + bestVal.getPeriod().getIndex());
        }
        return bestVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TabuItem
    implements Comparable<TabuItem> {
        private Object iObject;
        private long iIteration;

        public TabuItem(Object object, long iteration) {
            this.iObject = object;
            this.iIteration = iteration;
        }

        public Object getObject() {
            return this.iObject;
        }

        public long getIteration() {
            return this.iIteration;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof TabuItem)) {
                return false;
            }
            return this.getObject().equals(((TabuItem)object).getObject());
        }

        public int hashCode() {
            return this.getObject().hashCode();
        }

        @Override
        public int compareTo(TabuItem o) {
            return Double.compare(this.getIteration(), o.getIteration());
        }

        public String toString() {
            return this.getObject().toString();
        }
    }

    private static class TabuList {
        private HashSet<TabuItem> iList = new HashSet();
        private int iSize;
        private long iIteration = 0L;

        public TabuList(int size) {
            this.iSize = size;
        }

        public Object add(Object object) {
            if (this.iSize == 0) {
                return object;
            }
            if (this.contains(object)) {
                this.iList.remove(new TabuItem(object, 0L));
                this.iList.add(new TabuItem(object, this.iIteration++));
                return null;
            }
            Object oldest = null;
            if (this.iList.size() >= this.iSize) {
                oldest = this.removeOldest();
            }
            this.iList.add(new TabuItem(object, this.iIteration++));
            return oldest;
        }

        public void resize(int newSize) {
            this.iSize = newSize;
            while (this.iList.size() > newSize) {
                this.removeOldest();
            }
        }

        public boolean contains(Object object) {
            return this.iList.contains(new TabuItem(object, 0L));
        }

        public void clear() {
            this.iList.clear();
        }

        public int size() {
            return this.iSize;
        }

        public Object removeOldest() {
            TabuItem oldest = null;
            for (TabuItem element : this.iList) {
                if (oldest != null && oldest.getIteration() <= element.getIteration()) continue;
                oldest = element;
            }
            if (oldest == null) {
                return null;
            }
            this.iList.remove(oldest);
            return oldest.getObject();
        }

        public String toString() {
            return new TreeSet<TabuItem>(this.iList).toString();
        }
    }
}

