/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.heuristics;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.neighbours.ExamRandomMove;
import net.sf.cpsolver.exam.neighbours.ExamRoomMove;
import net.sf.cpsolver.exam.neighbours.ExamTimeMove;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.LazyNeighbour;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solution.SolutionListener;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamSimulatedAnnealing
implements NeighbourSelection<Exam, ExamPlacement>,
SolutionListener<Exam, ExamPlacement>,
LazyNeighbour.LazyNeighbourAcceptanceCriterion<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamSimulatedAnnealing.class);
    private static DecimalFormat sDF2 = new DecimalFormat("0.00");
    private static DecimalFormat sDF5 = new DecimalFormat("0.00000");
    private static DecimalFormat sDF10 = new DecimalFormat("0.0000000000");
    private double iInitialTemperature = 1.5;
    private double iCoolingRate = 0.95;
    private double iReheatRate = -1.0;
    private long iTemperatureLength = 250000L;
    private long iReheatLength = 0L;
    private long iRestoreBestLength = 0L;
    private double iTemperature = 0.0;
    private double iReheatLengthCoef = 5.0;
    private double iRestoreBestLengthCoef = -1.0;
    private long iIter = 0L;
    private long iLastImprovingIter = 0L;
    private long iLastReheatIter = 0L;
    private long iLastCoolingIter = 0L;
    private int[] iAcceptIter = new int[]{0, 0, 0};
    private boolean iStochasticHC = false;
    private int iMoves = 0;
    private double iAbsValue = 0.0;
    private long iT0 = -1L;
    private double iBestValue = 0.0;
    private Progress iProgress = null;
    private boolean iActive;
    private List<NeighbourSelection<Exam, ExamPlacement>> iNeighbours = null;
    private boolean iRelativeAcceptance = true;

    public ExamSimulatedAnnealing(DataProperties properties) {
        this.iInitialTemperature = properties.getPropertyDouble("SimulatedAnnealing.InitialTemperature", this.iInitialTemperature);
        this.iReheatRate = properties.getPropertyDouble("SimulatedAnnealing.ReheatRate", this.iReheatRate);
        this.iCoolingRate = properties.getPropertyDouble("SimulatedAnnealing.CoolingRate", this.iCoolingRate);
        this.iRelativeAcceptance = properties.getPropertyBoolean("SimulatedAnnealing.RelativeAcceptance", this.iRelativeAcceptance);
        this.iStochasticHC = properties.getPropertyBoolean("SimulatedAnnealing.StochasticHC", this.iStochasticHC);
        this.iTemperatureLength = properties.getPropertyLong("SimulatedAnnealing.TemperatureLength", this.iTemperatureLength);
        this.iReheatLengthCoef = properties.getPropertyDouble("SimulatedAnnealing.ReheatLengthCoef", this.iReheatLengthCoef);
        this.iRestoreBestLengthCoef = properties.getPropertyDouble("SimulatedAnnealing.RestoreBestLengthCoef", this.iRestoreBestLengthCoef);
        if (this.iReheatRate < 0.0) {
            this.iReheatRate = Math.pow(1.0 / this.iCoolingRate, this.iReheatLengthCoef * 1.7);
        }
        if (this.iRestoreBestLengthCoef < 0.0) {
            this.iRestoreBestLengthCoef = this.iReheatLengthCoef * this.iReheatLengthCoef;
        }
        String neighbours = properties.getProperty("SimulatedAnnealing.Neighbours", ExamRandomMove.class.getName() + ";" + ExamRoomMove.class.getName() + ";" + ExamTimeMove.class.getName());
        neighbours = neighbours + ";" + properties.getProperty("SimulatedAnnealing.AdditionalNeighbours", "");
        this.iNeighbours = new ArrayList<NeighbourSelection<Exam, ExamPlacement>>();
        for (String neighbour : neighbours.split("\\;")) {
            if (neighbour == null || neighbour.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(neighbour);
                this.iNeighbours.add((NeighbourSelection<Exam, ExamPlacement>)clazz.getConstructor(DataProperties.class).newInstance(properties));
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to use " + neighbour + ": " + e.getMessage()));
            }
        }
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        this.iTemperature = this.iInitialTemperature;
        this.iReheatLength = Math.round(this.iReheatLengthCoef * (double)this.iTemperatureLength);
        this.iRestoreBestLength = Math.round(this.iRestoreBestLengthCoef * (double)this.iTemperatureLength);
        solver.currentSolution().addSolutionListener(this);
        for (NeighbourSelection<Exam, ExamPlacement> neighbour : this.iNeighbours) {
            neighbour.init(solver);
        }
        solver.setUpdateProgress(false);
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        this.iActive = false;
    }

    protected void cool(Solution<Exam, ExamPlacement> solution) {
        this.iTemperature *= this.iCoolingRate;
        sLog.info((Object)("Iter=" + this.iIter / 1000L + "k, NonImpIter=" + sDF2.format((double)(this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + sDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s"));
        sLog.info((Object)("Temperature decreased to " + sDF5.format(this.iTemperature) + " " + "(#moves=" + this.iMoves + ", rms(value)=" + sDF2.format(Math.sqrt(this.iAbsValue / (double)this.iMoves)) + ", " + "accept=-" + sDF2.format(100.0 * (double)this.iAcceptIter[0] / (double)this.iTemperatureLength) + "/" + sDF2.format(100.0 * (double)this.iAcceptIter[1] / (double)this.iTemperatureLength) + "/+" + sDF2.format(100.0 * (double)this.iAcceptIter[2] / (double)this.iTemperatureLength) + "%, " + (this.prob(-1.0) < 1.0 ? "p(-1)=" + sDF2.format(100.0 * this.prob(-1.0)) + "%, " : "") + "p(+1)=" + sDF2.format(100.0 * this.prob(1.0)) + "%, " + "p(+10)=" + sDF5.format(100.0 * this.prob(10.0)) + "%)"));
        this.iLastCoolingIter = this.iIter;
        this.iAcceptIter = new int[]{0, 0, 0};
        this.iMoves = 0;
        this.iAbsValue = 0.0;
    }

    protected void reheat(Solution<Exam, ExamPlacement> solution) {
        this.iTemperature *= this.iReheatRate;
        sLog.info((Object)("Iter=" + this.iIter / 1000L + "k, NonImpIter=" + sDF2.format((double)(this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + sDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s"));
        sLog.info((Object)("Temperature increased to " + sDF5.format(this.iTemperature) + " " + (this.prob(-1.0) < 1.0 ? "p(-1)=" + sDF2.format(100.0 * this.prob(-1.0)) + "%, " : "") + "p(+1)=" + sDF2.format(100.0 * this.prob(1.0)) + "%, " + "p(+10)=" + sDF5.format(100.0 * this.prob(10.0)) + "%, " + "p(+100)=" + sDF10.format(100.0 * this.prob(100.0)) + "%)"));
        this.iLastReheatIter = this.iIter;
        this.iProgress.setPhase("Simulated Annealing [" + sDF2.format(this.iTemperature) + "]...");
    }

    protected void restoreBest(Solution<Exam, ExamPlacement> solution) {
        sLog.info((Object)"Best restored");
        this.iLastImprovingIter = this.iIter;
    }

    public Neighbour<Exam, ExamPlacement> genMove(Solution<Exam, ExamPlacement> solution) {
        NeighbourSelection<Exam, ExamPlacement> ns;
        Neighbour<Exam, ExamPlacement> n;
        do {
            this.incIter(solution);
        } while ((n = (ns = this.iNeighbours.get(ToolBox.random(this.iNeighbours.size()))).selectNeighbour(solution)) == null);
        return n;
    }

    protected double prob(double value) {
        if (this.iStochasticHC) {
            return 1.0 / (1.0 + Math.exp(value / this.iTemperature));
        }
        return value <= 0.0 ? 1.0 : Math.exp(-value / this.iTemperature);
    }

    protected boolean accept(Solution<Exam, ExamPlacement> solution, Neighbour<Exam, ExamPlacement> neighbour) {
        if (neighbour instanceof LazyNeighbour) {
            ((LazyNeighbour)neighbour).setAcceptanceCriterion(this);
            return true;
        }
        double value = this.iRelativeAcceptance ? neighbour.value() : solution.getModel().getTotalValue() + neighbour.value() - solution.getBestValue();
        double prob = this.prob(value);
        if (prob >= 1.0 || ToolBox.random() < prob) {
            int n = neighbour.value() < 0.0 ? 0 : (neighbour.value() > 0.0 ? 2 : 1);
            this.iAcceptIter[n] = this.iAcceptIter[n] + 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(LazyNeighbour<Exam, ExamPlacement> neighbour, double value) {
        double prob = this.prob(value);
        if (prob >= 1.0 || ToolBox.random() < prob) {
            int n = value < 0.0 ? 0 : (value > 0.0 ? 2 : 1);
            this.iAcceptIter[n] = this.iAcceptIter[n] + 1;
            return true;
        }
        return false;
    }

    protected void incIter(Solution<Exam, ExamPlacement> solution) {
        if (this.iT0 < 0L) {
            this.iT0 = JProf.currentTimeMillis();
        }
        ++this.iIter;
        if (this.iIter > this.iLastImprovingIter + this.iRestoreBestLength) {
            this.restoreBest(solution);
        }
        if (this.iIter > Math.max(this.iLastReheatIter, this.iLastImprovingIter) + this.iReheatLength) {
            this.reheat(solution);
        }
        if (this.iIter > this.iLastCoolingIter + this.iTemperatureLength) {
            this.cool(solution);
        }
        this.iProgress.setProgress(Math.round(100.0 * (double)(this.iIter - Math.max(this.iLastReheatIter, this.iLastImprovingIter)) / (double)this.iReheatLength));
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        if (!this.iActive) {
            this.iProgress.setPhase("Simulated Annealing [" + sDF2.format(this.iTemperature) + "]...");
            this.iActive = true;
        }
        Neighbour<Exam, ExamPlacement> neighbour = null;
        while ((neighbour = this.genMove(solution)) != null) {
            ++this.iMoves;
            this.iAbsValue += neighbour.value() * neighbour.value();
            if (!this.accept(solution, neighbour)) continue;
        }
        if (neighbour == null) {
            this.iActive = false;
        }
        return neighbour == null ? null : neighbour;
    }

    @Override
    public void bestSaved(Solution<Exam, ExamPlacement> solution) {
        if (Math.abs(this.iBestValue - solution.getBestValue()) >= 1.0) {
            this.iLastImprovingIter = this.iIter;
            this.iBestValue = solution.getBestValue();
        }
        this.iLastImprovingIter = this.iIter;
    }

    @Override
    public void solutionUpdated(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info, Collection<Exam> variables) {
    }

    @Override
    public void bestCleared(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public void bestRestored(Solution<Exam, ExamPlacement> solution) {
    }
}

