/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.neighbours.ExamRandomMove;
import net.sf.cpsolver.exam.neighbours.ExamRoomMove;
import net.sf.cpsolver.exam.neighbours.ExamTimeMove;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.LazyNeighbour;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solution.SolutionListener;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamHillClimbing
implements NeighbourSelection<Exam, ExamPlacement>,
SolutionListener<Exam, ExamPlacement>,
LazyNeighbour.LazyNeighbourAcceptanceCriterion<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamHillClimbing.class);
    private List<NeighbourSelection<Exam, ExamPlacement>> iNeighbours = null;
    private int iMaxIdleIters = 25000;
    private int iLastImprovingIter = 0;
    private double iBestValue = 0.0;
    private int iIter = 0;
    private Progress iProgress = null;
    private boolean iActive;
    private String iName = "Hill climbing";

    public ExamHillClimbing(DataProperties properties) {
        this(properties, "Hill Climbing");
    }

    public ExamHillClimbing(DataProperties properties, String name) {
        this.iMaxIdleIters = properties.getPropertyInt("HillClimber.MaxIdle", this.iMaxIdleIters);
        String neighbours = properties.getProperty("HillClimber.Neighbours", ExamRandomMove.class.getName() + ";" + ExamRoomMove.class.getName() + ";" + ExamTimeMove.class.getName());
        neighbours = neighbours + ";" + properties.getProperty("HillClimber.AdditionalNeighbours", "");
        this.iNeighbours = new ArrayList<NeighbourSelection<Exam, ExamPlacement>>();
        for (String neighbour : neighbours.split("\\;")) {
            if (neighbour == null || neighbour.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(neighbour);
                this.iNeighbours.add((NeighbourSelection<Exam, ExamPlacement>)clazz.getConstructor(DataProperties.class).newInstance(properties));
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to use " + neighbour + ": " + e.getMessage()));
            }
        }
        this.iName = name;
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        solver.currentSolution().addSolutionListener(this);
        for (NeighbourSelection<Exam, ExamPlacement> neighbour : this.iNeighbours) {
            neighbour.init(solver);
        }
        solver.setUpdateProgress(false);
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        this.iActive = false;
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        block3: {
            Neighbour<Exam, ExamPlacement> n;
            if (!this.iActive) {
                this.iProgress.setPhase(this.iName + "...");
                this.iActive = true;
            }
            while (true) {
                ++this.iIter;
                this.iProgress.setProgress(Math.round(100.0 * (double)(this.iIter - this.iLastImprovingIter) / (double)this.iMaxIdleIters));
                if (this.iIter - this.iLastImprovingIter >= this.iMaxIdleIters) break block3;
                NeighbourSelection<Exam, ExamPlacement> ns = this.iNeighbours.get(ToolBox.random(this.iNeighbours.size()));
                n = ns.selectNeighbour(solution);
                if (n == null) continue;
                if (n instanceof LazyNeighbour) {
                    ((LazyNeighbour)n).setAcceptanceCriterion(this);
                    return n;
                }
                if (n.value() <= 0.0) break;
            }
            return n;
        }
        this.iIter = 0;
        this.iLastImprovingIter = 0;
        this.iActive = false;
        return null;
    }

    @Override
    public void bestSaved(Solution<Exam, ExamPlacement> solution) {
        if (Math.abs(this.iBestValue - solution.getBestValue()) >= 1.0) {
            this.iLastImprovingIter = this.iIter;
            this.iBestValue = solution.getBestValue();
        }
    }

    @Override
    public void solutionUpdated(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info, Collection<Exam> variables) {
    }

    @Override
    public void bestCleared(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public void bestRestored(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public boolean accept(LazyNeighbour<Exam, ExamPlacement> neighbour, double value) {
        return value <= 0.0;
    }
}

