/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria.additional;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodViolation
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exam.SoftPeriods";
    }

    @Override
    public String getXmlWeightName() {
        return "softPeriods";
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        return (double)value.getPeriodPlacement().getExamPenalty() == this.getWeight() || (double)value.getPeriodPlacement().getPeriod().getPenalty() == this.getWeight() ? 1.0 : 0.0;
    }

    @Override
    public double[] getBounds(Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        block0: for (Exam exam : variables) {
            if (exam.getPeriodPlacements().isEmpty()) continue;
            for (ExamPeriodPlacement periodPlacement : exam.getPeriodPlacements()) {
                if ((double)periodPlacement.getExamPenalty() != this.getWeight() && (double)periodPlacement.getPeriod().getPenalty() != this.getWeight()) continue;
                bounds[1] = bounds[1] + 1.0;
                continue block0;
            }
        }
        return bounds;
    }

    public String toString() {
        return this.getValue() <= 0.0 ? "" : "!P:" + sDoubleFormat.format(this.getValue());
    }
}

