/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria.additional;

import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamDistributionConstraint;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPlacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionViolation
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exam.SoftDistributions";
    }

    @Override
    public String getXmlWeightName() {
        return "softDistributions";
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            boolean sat;
            if (dc.isHard() || this.getWeight() != (double)dc.getWeight() || (sat = dc.isSatisfied(value)) == dc.isSatisfied()) continue;
            penalty = (int)((double)penalty + (sat ? -1.0 : 1.0));
        }
        return penalty;
    }

    @Override
    protected double[] computeBounds() {
        double[] bounds = new double[]{0.0, 0.0};
        for (ExamDistributionConstraint dc : ((ExamModel)this.getModel()).getDistributionConstraints()) {
            if (dc.isHard() || this.getWeight() != (double)dc.getWeight()) continue;
            bounds[1] = bounds[1] + 1.0;
        }
        return bounds;
    }

    @Override
    public boolean isRoomCriterion() {
        return true;
    }

    @Override
    public double getRoomValue(ExamPlacement value) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            boolean sat;
            if (dc.isHard() || this.getWeight() != (double)dc.getWeight() || !dc.isRoomRelated() || (sat = dc.isSatisfied(value)) == dc.isSatisfied()) continue;
            penalty = (int)((double)penalty + (sat ? -1.0 : 1.0));
        }
        return penalty;
    }

    @Override
    public boolean isPeriodCriterion() {
        return true;
    }

    @Override
    public double getPeriodValue(ExamPlacement value) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            boolean sat;
            if (dc.isHard() || this.getWeight() != (double)dc.getWeight() || !dc.isPeriodRelated() || (sat = dc.isSatisfied(value)) == dc.isSatisfied()) continue;
            penalty = (int)((double)penalty + (sat ? -1.0 : 1.0));
        }
        return penalty;
    }

    public String toString() {
        return this.getValue() <= 0.0 ? "" : "!D:" + sDoubleFormat.format(this.getValue());
    }
}

