/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria.additional;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceToStronglyPreferredRoom
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.DistanceToStronglyPreferredRoomWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "distanceToStronglyPreferredRoomWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.001;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Average ret = new Average();
        for (ExamRoomPlacement assigned : value.getRoomPlacements()) {
            for (ExamRoomPlacement preferred : ((Exam)value.variable()).getRoomPlacements()) {
                if (preferred.getPenalty() >= -2) continue;
                ret.add(assigned.getDistanceInMeters(preferred));
            }
        }
        return ret.average();
    }

    public String toString() {
        return "@D:" + sDoubleFormat.format(this.getValue() / (double)this.getModel().assignedVariables().size());
    }

    @Override
    public double[] getBounds() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getValue() > 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue() / (double)this.getModel().assignedVariables().size()) + " m");
        }
    }

    private static class Average {
        double iValue = 0.0;
        int iCount = 0;

        private Average() {
        }

        private void add(double value) {
            this.iValue += value;
            ++this.iCount;
        }

        public double average() {
            return this.iCount == 0 ? 0.0 : this.iValue / (double)this.iCount;
        }
    }
}

