/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamStudent;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentDistanceBackToBackConflicts
extends ExamCriterion {
    private double iBackToBackDistance = -1.0;

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        boolean ret = super.init(solver);
        this.iBackToBackDistance = solver.getProperties().getPropertyDouble("Exams.BackToBackDistance", this.iBackToBackDistance);
        return ret;
    }

    @Override
    public String getWeightName() {
        return "Exams.DistanceBackToBackConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "distanceBackToBackConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 25.0;
    }

    public double getBackToBackDistance() {
        return this.iBackToBackDistance;
    }

    public void setBackToBackDistance(double backToBackDistance) {
        this.iBackToBackDistance = backToBackDistance;
    }

    @Override
    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
        params.put("backToBackDistance", String.valueOf(this.getBackToBackDistance()));
    }

    @Override
    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.setBackToBackDistance(Double.valueOf(params.get("backToBackDistance")));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        if (this.getBackToBackDistance() < 0.0) {
            return 0.0;
        }
        int penalty = 0;
        for (ExamStudent s : exam.getStudents()) {
            if (value.getPeriod().prev() != null && value.getPeriod().prev().getDay() == value.getPeriod().getDay()) {
                for (Exam x : s.getExams(value.getPeriod().prev())) {
                    if (x.equals(exam) || !(value.getDistanceInMeters((ExamPlacement)x.getAssignment()) > this.getBackToBackDistance())) continue;
                    ++penalty;
                }
            }
            if (value.getPeriod().next() == null || value.getPeriod().next().getDay() != value.getPeriod().getDay()) continue;
            for (Exam x : s.getExams(value.getPeriod().next())) {
                if (x.equals(exam) || !(value.getDistanceInMeters((ExamPlacement)x.getAssignment()) > this.getBackToBackDistance())) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Distance Back-To-Back Conflicts";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getBackToBackDistance() >= 0.0 && this.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue()));
        }
    }

    public String toString() {
        return this.getValue() <= 0.0 ? "" : "BTBd:" + sDoubleFormat.format(this.getValue());
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

