/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.criteria.StudentNotAvailableConflicts;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamStudent;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentDirectConflicts
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.DirectConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "directConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1000.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        for (ExamStudent s : exam.getStudents()) {
            Set<Exam> exams = s.getExams(value.getPeriod());
            int nrExams = exams.size() + (exams.contains(exam) ? 0 : 1);
            if (nrExams <= 1) continue;
            ++penalty;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Direct Conflicts";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        StudentNotAvailableConflicts na = (StudentNotAvailableConflicts)this.getModel().getCriterion(StudentNotAvailableConflicts.class);
        if (this.getValue() != 0.0 || na != null && na.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue() + (na == null ? 0.0 : na.getValue())) + (na == null || na.getValue() == 0.0 ? "" : " (" + sDoubleFormat.format(na.getValue()) + " N/A)"));
        }
    }

    public String toString() {
        return "DC:" + sDoubleFormat.format(this.getValue());
    }
}

