/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomSplitPenalty
extends ExamCriterion {
    private int[] iRoomSplits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public String getWeightName() {
        return "Exams.RoomSplitWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "roomSplitWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 10.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        return value.getRoomPlacements() == null || value.getRoomPlacements().size() <= 1 ? 0 : (value.getRoomPlacements().size() - 1) * (value.getRoomPlacements().size() - 1);
    }

    @Override
    public void beforeUnassigned(long iteration, ExamPlacement value) {
        super.beforeUnassigned(iteration, value);
        if (value.getRoomPlacements() == null || value.getRoomPlacements().size() > 1) {
            int n = value.getRoomPlacements().size() - 2;
            this.iRoomSplits[n] = this.iRoomSplits[n] - 1;
        }
    }

    @Override
    public void afterAssigned(long iteration, ExamPlacement value) {
        super.afterAssigned(iteration, value);
        if (value.getRoomPlacements() == null || value.getRoomPlacements().size() > 1) {
            int n = value.getRoomPlacements().size() - 2;
            this.iRoomSplits[n] = this.iRoomSplits[n] + 1;
        }
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getValue() != 0.0) {
            String split = "";
            for (int i = 0; i < this.iRoomSplits.length; ++i) {
                if (this.iRoomSplits[i] <= 0) continue;
                if (split.length() > 0) {
                    split = split + ", ";
                }
                split = split + this.iRoomSplits[i] + "&times;" + (i + 2);
            }
            info.put(this.getName(), sDoubleFormat.format(this.getValue()) + " (" + split + ")");
        }
    }

    public String toString() {
        return "RSp:" + sDoubleFormat.format(this.getValue());
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

