/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomSplitDistancePenalty
extends ExamCriterion {
    private int iRoomSplits = 0;

    @Override
    public String getWeightName() {
        return "Exams.RoomSplitDistanceWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "roomSplitDistanceWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.01;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        if (value.getRoomPlacements() == null || value.getRoomPlacements().size() <= 1) {
            return 0.0;
        }
        double distance = 0.0;
        for (ExamRoomPlacement r : value.getRoomPlacements()) {
            for (ExamRoomPlacement w : value.getRoomPlacements()) {
                if (r.getRoom().getId() >= w.getRoom().getId()) continue;
                distance += r.getRoom().getDistanceInMeters(w.getRoom());
            }
        }
        int pairs = value.getRoomPlacements().size() * (value.getRoomPlacements().size() - 1) / 2;
        return distance / (double)pairs;
    }

    @Override
    public void beforeUnassigned(long iteration, ExamPlacement value) {
        super.beforeUnassigned(iteration, value);
        if (value.getRoomPlacements() == null || value.getRoomPlacements().size() > 1) {
            --this.iRoomSplits;
        }
    }

    @Override
    public void afterAssigned(long iteration, ExamPlacement value) {
        super.afterAssigned(iteration, value);
        if (value.getRoomPlacements() == null || value.getRoomPlacements().size() > 1) {
            ++this.iRoomSplits;
        }
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue() / (double)this.iRoomSplits) + " m");
        }
    }

    public int nrRoomSplits() {
        return this.iRoomSplits;
    }

    public String toString() {
        return "RSd:" + sDoubleFormat.format(this.getValue() / (double)this.iRoomSplits);
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

