/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.criteria.additional.RoomViolation;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPeriod;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoom;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomPenalty
extends ExamCriterion {
    protected Integer iSoftRooms = null;

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        if (super.init(solver)) {
            this.iSoftRooms = solver.getProperties().getPropertyInteger("Exam.SoftRooms", null);
            if (this.iSoftRooms != null) {
                RoomViolation rv = new RoomViolation();
                this.getModel().addCriterion(rv);
                return rv.init(solver);
            }
        }
        return true;
    }

    @Override
    public String getWeightName() {
        return "Exams.RoomWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "roomWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.1;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        double penalty = 0.0;
        if (value.getRoomPlacements() != null) {
            for (ExamRoomPlacement r : value.getRoomPlacements()) {
                penalty += this.iSoftRooms != null && (this.iSoftRooms.intValue() == r.getPenalty() || this.iSoftRooms.intValue() == r.getPenalty(value.getPeriod())) ? 0.0 : (double)r.getPenalty(value.getPeriod());
            }
        }
        return penalty;
    }

    private int getMinPenalty(ExamRoom r) {
        int min = Integer.MAX_VALUE;
        for (ExamPeriod p : ((ExamModel)this.getModel()).getPeriods()) {
            if (!r.isAvailable(p) || this.iSoftRooms != null && r.getPenalty(p) == this.iSoftRooms.intValue()) continue;
            min = Math.min(min, r.getPenalty(p));
        }
        return min;
    }

    private int getMaxPenalty(ExamRoom r) {
        int max = Integer.MIN_VALUE;
        for (ExamPeriod p : ((ExamModel)this.getModel()).getPeriods()) {
            if (!r.isAvailable(p) || this.iSoftRooms != null && r.getPenalty(p) == this.iSoftRooms.intValue()) continue;
            max = Math.max(max, r.getPenalty(p));
        }
        return max;
    }

    private boolean isAvailable(ExamRoom r) {
        for (ExamPeriod p : ((ExamModel)this.getModel()).getPeriods()) {
            if (!r.isAvailable(p) || this.iSoftRooms != null && r.getPenalty(p) == this.iSoftRooms.intValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double[] getBounds(Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Exam exam : variables) {
            if (exam.getRoomPlacements().isEmpty()) continue;
            int minPenalty = Integer.MAX_VALUE;
            int maxPenalty = Integer.MIN_VALUE;
            for (ExamRoomPlacement roomPlacement : exam.getRoomPlacements()) {
                if (this.iSoftRooms != null && this.iSoftRooms.intValue() == roomPlacement.getPenalty() || !this.isAvailable(roomPlacement.getRoom())) continue;
                minPenalty = Math.min(minPenalty, 2 * roomPlacement.getPenalty() + this.getMinPenalty(roomPlacement.getRoom()));
                maxPenalty = Math.max(maxPenalty, 2 * roomPlacement.getPenalty() + this.getMaxPenalty(roomPlacement.getRoom()));
            }
            bounds[0] = bounds[0] + (double)minPenalty;
            bounds[1] = bounds[1] + (double)maxPenalty;
        }
        return bounds;
    }

    public String toString() {
        return "RP:" + sDoubleFormat.format(this.getValue());
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

