/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerturbationPenalty
extends ExamCriterion {
    private boolean iMPP = false;

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        boolean ret = super.init(solver);
        this.iMPP = solver.getProperties().getPropertyBoolean("General.MPP", this.iMPP);
        return ret;
    }

    @Override
    public String getWeightName() {
        return "Exams.PerturbationWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "perturbationWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.01;
    }

    public boolean isMPP() {
        return this.iMPP;
    }

    @Override
    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
        params.put("mpp", this.isMPP() ? "true" : "false");
    }

    @Override
    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.iMPP = "true".equals(params.get("mpp"));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        if (!this.isMPP()) {
            return 0.0;
        }
        Exam exam = (Exam)value.variable();
        ExamPlacement initial = (ExamPlacement)exam.getInitialAssignment();
        if (initial == null) {
            return 0.0;
        }
        return Math.abs(initial.getPeriod().getIndex() - value.getPeriod().getIndex()) * (1 + exam.getSize());
    }

    public String toString() {
        return this.isMPP() ? "IP:" + sDoubleFormat.format(this.getValue()) : "";
    }
}

