/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodSizePenalty
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.PeriodSizeWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "periodSizeWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        return value.getPeriodPlacement().getPenalty() * (((Exam)value.variable()).getSize() + 1);
    }

    @Override
    public String getName() {
        return "Period&times;Size Penalty";
    }

    @Override
    public double[] getBounds(Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Exam exam : variables) {
            if (exam.getPeriodPlacements().isEmpty()) continue;
            int minSizePenalty = Integer.MAX_VALUE;
            int maxSizePenalty = Integer.MIN_VALUE;
            for (ExamPeriodPlacement periodPlacement : exam.getPeriodPlacements()) {
                minSizePenalty = Math.min(minSizePenalty, periodPlacement.getPenalty() * (exam.getSize() + 1));
                maxSizePenalty = Math.max(maxSizePenalty, periodPlacement.getPenalty() * (exam.getSize() + 1));
            }
            bounds[0] = bounds[0] + (double)minSizePenalty;
            bounds[1] = bounds[1] + (double)maxSizePenalty;
        }
        return bounds;
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue() / (double)this.getModel().nrAssignedVariables()));
        }
    }

    public String toString() {
        return "PS:" + sDoubleFormat.format(this.getValue() / (double)this.getModel().nrAssignedVariables());
    }
}

