/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Set;
import net.sf.cpsolver.exam.criteria.StudentMoreThan2ADayConflicts;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamInstructor;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorMoreThan2ADayConflicts
extends StudentMoreThan2ADayConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorMoreThanTwoADayWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorMoreThanTwoADayWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 100.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        for (ExamInstructor s : exam.getInstructors()) {
            Set<Exam> exams = s.getExamsADay(value.getPeriod());
            int nrExams = exams.size() + (exams.contains(exam) ? 0 : 1);
            if (nrExams <= 2) continue;
            ++penalty;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Instructor More Than 2 A Day Conflicts";
    }

    @Override
    public String toString() {
        return "iM2D:" + sDoubleFormat.format(this.getValue());
    }
}

