/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Set;
import net.sf.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamInstructor;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorDistanceBackToBackConflicts
extends StudentDistanceBackToBackConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorDistanceBackToBackConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorDistanceBackToBackConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 25.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        double btbDist = this.getBackToBackDistance();
        if (btbDist < 0.0) {
            return 0.0;
        }
        int penalty = 0;
        for (ExamInstructor s : exam.getInstructors()) {
            if (value.getPeriod().prev() != null && value.getPeriod().prev().getDay() == value.getPeriod().getDay()) {
                for (Exam x : s.getExams(value.getPeriod().prev())) {
                    if (x.equals(exam) || !(value.getDistanceInMeters((ExamPlacement)x.getAssignment()) > btbDist)) continue;
                    ++penalty;
                }
            }
            if (value.getPeriod().next() == null || value.getPeriod().next().getDay() != value.getPeriod().getDay()) continue;
            for (Exam x : s.getExams(value.getPeriod().next())) {
                if (x.equals(exam) || !(value.getDistanceInMeters((ExamPlacement)x.getAssignment()) > btbDist)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Instructor Distance Back-To-Back Conflicts";
    }

    @Override
    public String toString() {
        return this.getValue() <= 0.0 ? "" : "iBTBd:" + sDoubleFormat.format(this.getValue());
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

