/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.InstructorNotAvailableConflicts;
import net.sf.cpsolver.exam.criteria.StudentDirectConflicts;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamInstructor;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorDirectConflicts
extends StudentDirectConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorDirectConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorDirectConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1000.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        for (ExamInstructor s : exam.getInstructors()) {
            Set<Exam> exams = s.getExams(value.getPeriod());
            int nrExams = exams.size() + (exams.contains(exam) ? 0 : 1);
            if (nrExams <= 1) continue;
            ++penalty;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Instructor Direct Conflicts";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        InstructorNotAvailableConflicts na = (InstructorNotAvailableConflicts)this.getModel().getCriterion(InstructorNotAvailableConflicts.class);
        if (this.getValue() != 0.0 || na != null && na.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue() + (na == null ? 0.0 : na.getValue())) + (na == null || na.getValue() == 0.0 ? "" : " (" + sDoubleFormat.format(na.getValue()) + " N/A)"));
        }
    }

    @Override
    public String toString() {
        return "iDC:" + sDoubleFormat.format(this.getValue());
    }
}

