/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Set;
import net.sf.cpsolver.exam.criteria.StudentBackToBackConflicts;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamInstructor;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorBackToBackConflicts
extends StudentBackToBackConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorBackToBackConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorBackToBackConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 10.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        for (ExamInstructor s : exam.getInstructors()) {
            int nrExams;
            Set<Exam> exams;
            if (value.getPeriod().prev() != null && (this.isDayBreakBackToBack() || value.getPeriod().prev().getDay() == value.getPeriod().getDay())) {
                exams = s.getExams(value.getPeriod().prev());
                nrExams = exams.size() + (exams.contains(exam) ? -1 : 0);
                penalty += nrExams;
            }
            if (value.getPeriod().next() == null || !this.isDayBreakBackToBack() && value.getPeriod().next().getDay() != value.getPeriod().getDay()) continue;
            exams = s.getExams(value.getPeriod().next());
            nrExams = exams.size() + (exams.contains(exam) ? -1 : 0);
            penalty += nrExams;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Instructor Back-To-Back Conflicts";
    }

    @Override
    public String toString() {
        return "iBTB:" + sDoubleFormat.format(this.getValue());
    }
}

