/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamRotationPenalty
extends ExamCriterion {
    private int iAssignedExamsWithAvgPeriod = 0;
    private double iAveragePeriod = 0.0;

    @Override
    public String getWeightName() {
        return "Exams.RotationWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "examRotationWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.001;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        if (((Exam)value.variable()).getAveragePeriod() < 0) {
            return 0.0;
        }
        return (1 + value.getPeriod().getIndex()) * (1 + ((Exam)value.variable()).getAveragePeriod());
    }

    @Override
    public void beforeUnassigned(long iteration, ExamPlacement value) {
        super.beforeUnassigned(iteration, value);
        if (((Exam)value.variable()).getAveragePeriod() >= 0) {
            --this.iAssignedExamsWithAvgPeriod;
            this.iAveragePeriod -= (double)((Exam)value.variable()).getAveragePeriod();
        }
    }

    @Override
    public void afterAssigned(long iteration, ExamPlacement value) {
        super.afterAssigned(iteration, value);
        if (((Exam)value.variable()).getAveragePeriod() >= 0) {
            ++this.iAssignedExamsWithAvgPeriod;
            this.iAveragePeriod += (double)((Exam)value.variable()).getAveragePeriod();
        }
    }

    public int nrAssignedExamsWithAvgPeriod() {
        return this.iAssignedExamsWithAvgPeriod;
    }

    public double averagePeriod() {
        return this.iAveragePeriod / (double)this.iAssignedExamsWithAvgPeriod;
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(Math.sqrt(this.getValue() / (double)this.iAssignedExamsWithAvgPeriod) - 1.0));
        }
    }

    public String toString() {
        return "@P:" + sDoubleFormat.format(Math.sqrt(this.getValue() / (double)this.iAssignedExamsWithAvgPeriod) - 1.0);
    }
}

