/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExamCriterion
extends AbstractCriterion<Exam, ExamPlacement> {
    public void setWeight(double weight) {
        this.iWeight = weight;
    }

    @Override
    public String getWeightName() {
        return "Exams." + this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)) + "Weight";
    }

    @Override
    public double[] getBounds(Collection<Exam> exams) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Exam exam : exams) {
            Double min = null;
            Double max = null;
            for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
                if (exam.getMaxRooms() == 0) {
                    double value = this.getValue(new ExamPlacement(exam, period, null), null);
                    if (min == null) {
                        min = value;
                        max = value;
                        continue;
                    }
                    min = Math.min(min, value);
                    max = Math.max(max, value);
                    continue;
                }
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
                    rooms.add(room);
                    double value = this.getValue(new ExamPlacement(exam, period, rooms), null);
                    if (min == null) {
                        min = value;
                        max = value;
                        continue;
                    }
                    min = Math.min(min, value);
                    max = Math.max(max, value);
                }
            }
            if (min == null) continue;
            bounds[0] = bounds[0] + min;
            bounds[1] = bounds[1] + max;
        }
        return bounds;
    }

    @Override
    public void getInfo(Map<String, String> info) {
        double val = this.getValue();
        double[] bounds = this.getBounds();
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            info.put(this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (" + sDoubleFormat.format(val) + ")");
        } else if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0]) {
            info.put(this.getName(), this.getPercRev(val, bounds[1], bounds[0]) + "% (" + sDoubleFormat.format(val) + ")");
        } else if (bounds[0] != val || val != bounds[1]) {
            info.put(this.getName(), sDoubleFormat.format(val));
        }
    }

    public boolean isPeriodCriterion() {
        return true;
    }

    public double getPeriodValue(ExamPlacement value) {
        return this.isPeriodCriterion() ? this.getValue(value, null) : 0.0;
    }

    public boolean isRoomCriterion() {
        return !this.isPeriodCriterion();
    }

    public double getRoomValue(ExamPlacement value) {
        return this.isRoomCriterion() ? this.getValue(value, null) : 0.0;
    }

    public String getXmlWeightName() {
        String name = this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46));
        return Character.toString(name.charAt(0)) + name.substring(1);
    }

    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
    }

    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

