/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.criteria.additional.DistributionViolation;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamDistributionConstraint;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionPenalty
extends ExamCriterion {
    protected Integer iSoftDistributions = null;

    public DistributionPenalty() {
        this.iValueUpdateType = AbstractCriterion.ValueUpdateType.NoUpdate;
    }

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        if (super.init(solver)) {
            this.iSoftDistributions = solver.getProperties().getPropertyInteger("Exam.SoftDistributions", null);
            if (this.iSoftDistributions != null) {
                DistributionViolation dv = new DistributionViolation();
                this.getModel().addCriterion(dv);
                return dv.init(solver);
            }
        }
        return true;
    }

    @Override
    public String getWeightName() {
        return "Exams.DistributionWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "distributionWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            boolean sat;
            if (dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight() || (sat = dc.isSatisfied(value)) == dc.isSatisfied()) continue;
            penalty += sat ? -dc.getWeight() : dc.getWeight();
        }
        return penalty;
    }

    @Override
    public boolean isRoomCriterion() {
        return true;
    }

    @Override
    public double getRoomValue(ExamPlacement value) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            boolean sat;
            if (dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight() || !dc.isRoomRelated() || (sat = dc.isSatisfied(value)) == dc.isSatisfied()) continue;
            penalty += sat ? -dc.getWeight() : dc.getWeight();
        }
        return penalty;
    }

    @Override
    public boolean isPeriodCriterion() {
        return true;
    }

    @Override
    public void inc(double value) {
        if (this.iSoftDistributions != null && (double)this.iSoftDistributions.intValue() == value) {
            this.getModel().getCriterion(DistributionViolation.class).inc(1.0);
        } else if (this.iSoftDistributions != null && (double)this.iSoftDistributions.intValue() == -value) {
            this.getModel().getCriterion(DistributionViolation.class).inc(-1.0);
        } else {
            super.inc(value);
        }
    }

    @Override
    public double getPeriodValue(ExamPlacement value) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            boolean sat;
            if (dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight() || !dc.isPeriodRelated() || (sat = dc.isSatisfied(value)) == dc.isSatisfied()) continue;
            penalty += sat ? -dc.getWeight() : dc.getWeight();
        }
        return penalty;
    }

    @Override
    protected double[] computeBounds() {
        double[] bounds = new double[]{0.0, 0.0};
        for (ExamDistributionConstraint dc : ((ExamModel)this.getModel()).getDistributionConstraints()) {
            if (dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight()) continue;
            bounds[1] = bounds[1] + (double)dc.getWeight();
        }
        return bounds;
    }

    public String toString() {
        return this.getValue() <= 0.0 ? "" : "DP:" + sDoubleFormat.format(this.getValue());
    }
}

